/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfUpdateRange;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MicrocodeFunctionRequestBody
extends XFrameRsfRequestBody {
    private static final String TRACE_MASKT = "XRSFXF T";
    private static final String TRACE_MASKF = "XRSFXF F";
    private static final String TRACE_MASKD = "XRSFXF D";
    public static final char DOWNLOAD = '0';
    public static final char CHECK_ON_HOLD_STATUS = '1';
    public static final int RESULT_NO_REQUESTED_UPDATES_AVAILABLE = 100;
    private String path;
    private Collection updateRangeList;

    public static Collection convertUpdateRangeCollection(Collection updateRangeCollection) throws IllegalArgumentException {
        if (updateRangeCollection == null) {
            throw new IllegalArgumentException("Null updateRangeCollection");
        }
        ArrayList<RsfUpdateRange> rangeList = new ArrayList<RsfUpdateRange>();
        try {
            Iterator ranges = updateRangeCollection.iterator();
            while (ranges.hasNext()) {
                rangeList.add(new RsfUpdateRange((UpdateRange)ranges.next()));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("UpdateRangeCollection has an element that is not  an 'UpdateRange'");
        }
        return rangeList;
    }

    public MicrocodeFunctionRequestBody() {
        this.functionUserid = (char)50;
    }

    public MicrocodeFunctionRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.path = ((Persistent)data).path;
        this.updateRangeList = ((Persistent)data).updateRangeList;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.path = this.path;
        result.updateRangeList = this.updateRangeList;
        return result;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.functionId == ' ') {
            this.invalidMessage = "No Microcode function type specified.";
        } else if (this.path == null) {
            this.invalidMessage = "No staging path specified.";
        } else if (this.updateRangeList == null) {
            this.invalidMessage = "No update range list specified.";
        } else {
            return true;
        }
        Trace.trace(TRACE_MASKF, "MicrocodeFunctionRequestBody.isValid: " + this.invalidMessage);
        return false;
    }

    public void setFunctionType(char type) throws IllegalArgumentException {
        if (type != '0' && type != '1') {
            Trace.trace(TRACE_MASKF, "MicrocodeFunctionRequestBody.setFunctionType: invalid function type: '" + type + "'");
            throw new IllegalArgumentException("Invalid function type in MicrocodeFunctionRequestBody");
        }
        this.functionId = type;
    }

    public char getFunctionType() {
        return this.functionId;
    }

    public void setUpdateRangeList(Collection updateRanges) throws IllegalArgumentException {
        if (updateRanges == null) {
            throw new IllegalArgumentException();
        }
        this.updateRangeList = updateRanges;
    }

    public Collection getUpdateRangeList() {
        return this.updateRangeList;
    }

    public void setStagingPathname(String stagingPath) {
        this.path = stagingPath;
    }

    public String getStagingPathname() {
        return this.path;
    }

    private String buildUpdateRangeXmlFormat(boolean toString) {
        StringBuffer buffer;
        block7: {
            if (this.updateRangeList == null || this.updateRangeList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<MCLRLIST>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator mcls = this.updateRangeList.iterator();
                while (mcls.hasNext()) {
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append(((RsfUpdateRange)mcls.next()).toXmlTransferFormat());
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "Non-RsfUpdateRange object found in update range list");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</MCLRLIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        buffer.append(this.buildUpdateRangeXmlFormat(false));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        buffer.append(this.buildUpdateRangeXmlFormat(true));
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        String path;
        Collection updateRangeList;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

